`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 12/11/2023 10:07:39 PM
// Design Name: 
// Module Name: ram
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////
module ram(
        clk,
        oe,
        we,
        addr,
        in,
        out,
        disp_out
    );

parameter test_scenario = 0;
parameter width = 16;
parameter depth = 32;
parameter addr_width = 12;

input clk;
input oe;
input we;
input [addr_width-1 : 0]    addr;
input [width-1 : 0]         in;
output[width-1 : 0]         out;
output[width-1 : 0]         disp_out;

reg [width-1 : 0]           regs[depth-1 : 0];

reg [addr_width : 0]        i;

//WRITE Memory program
initial begin
    for(i = 0; i < depth; i = i + 1)
        regs[i] <= 0;
    
    case(test_scenario)
        0: begin //legacy
            regs[0] <= 'h1008 ;
            regs[1] <= 'h3007 ;
            regs[2] <= 'h9004 ;
            regs[3] <= 'h2009 ;
            regs[4] <= 'hE00A ;
            regs[5] <= 'h6000 ;
            regs[6] <= 'h7000 ;
            regs[7] <= 'h0005 ;
            regs[8] <= 'h000F ;
            regs[9] <= 'hFFFF ;
            regs[10]<= 'h000F ;
        end
        1: begin
            regs[0] <= 'h1005 ;
            regs[1] <= 'h4004 ;
            regs[2] <= 'h6000 ;
            regs[3] <= 'h7000 ;
            regs[4] <= 'h0005 ;
            regs[5] <= 'h000F ;
        end
        2: begin
            regs[0] <= 'h0003 ;
            regs[1] <= 'h7000 ;
            regs[2] <= 'h0000 ;
            regs[3] <= 'h0000 ;
            regs[4] <= 'h1007 ;
            regs[5] <= 'h6000 ;
            regs[6] <= 'h9001 ;
            regs[7] <= 'h000A ;
        end
        3: begin
            regs[0] <= 'hD004 ;
            regs[1] <= 'h2006 ;
            regs[2] <= 'h6000 ;
            regs[3] <= 'h7000 ;
            regs[4] <= 'h0005 ;
            regs[5] <= 'h000A ;
            regs[5] <= 'h000F ;
        end
        4: begin
            regs[0] <= 'hA652 ;
            regs[1] <= 'h6000 ;
            regs[2] <= 'h7000 ;
            regs[3] <= 'h0005 ;
            regs[4] <= 'h000F ;
        end
        5: begin
            regs[0] <= 'h1009 ;
            regs[1] <= 'h8400 ;
            regs[2] <= 'h9006 ;
            regs[3] <= 'h100A ;
            regs[4] <= 'h6000 ;
            regs[5] <= 'h9008 ;
            regs[6] <= 'h100B ;
            regs[7] <= 'h6000 ;
            regs[8] <= 'h7000 ;
            regs[9] <= 'h0000 ;
            regs[10]<= 'h0002 ;
            regs[11]<= 'h0003 ;
        end
    endcase

    //0 Legacy 
    /* 
        LOAD Y
        ADD X
        JUMP 4
        STORE Z
        StoreI K
        Output
        Halt
        
        X, DEC 5
        Y, DEC 15
        Z, HEX FFFF
        K, DEC 15
    */
    //1 Subst
    /*
    	LOAD Y
		SUBT X        
        Output
        Halt
        
        X, DEC 5
        Y, DEC 15
    */
    //2 JnS
    /*
        JnS 3
        Halt
        DEC 0
        DEC 0
        LOAD X
        OUTPUT
        JUMP 1
        
        X, DEC 10
    */
    //3 LoadI
    /*
        LoadI X        
        Store RESULT     
		OUTPUT 
        HALT

        
        X,      DEC 5          
        DATA,   DEC 10 
        RESULT, DEC 15
    */
    //4 LoadImmi
    /*
        LoadImmi 652 
        Output
        Halt
        
        X, DEC 5
        Y, DEC 15
    */
    //5 SkipCond
    /*
        if,		LOAD 		EXP			/ LOAD EXP into AC
                SKIPCOND	400			/ SKIPCOND 400 (if AC = 0)
                JUMP		else		/ JUMP to `else`
                LOAD		IVALUE  	/ LOAD IVALUE into AC
                OUTPUT					/ OUTPUT value IVALUE
                JUMP		end			/ JUMP to `end`
        
        else,	LOAD		EVALUE		/ LOAD IVALUE into AC
                OUTPUT					/ OUTPUT value IVALUE
        
        end,	HALT					/ HALT
        
        / variables
        EXP,	DEC			0
        IVALUE,	DEC			2
        EVALUE,	DEC			3
    */
end

always @(posedge clk) begin
    if(we)
        regs[addr] <= in;
end

assign out = oe ? regs[addr] : 0;
assign disp_out = regs[addr];

endmodule